/************************************************************************
PEFile - A class to manipulate portable executables for Win32
Copyright (C) 2006 Daniel "Lesco" Schoepe

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
************************************************************************/
/* Version 0.1 */

#ifndef INC_PEFILE_H
#define INC_PEFILE_H

#include <windows.h>

class PEFile
{
public:
	PEFile();
	PEFile(const char* filename);
	void openFile(const char* filename);
	void enlargeFile(DWORD bytes);
	void shrinkFile(DWORD bytes);
	void setSize(DWORD bytes);
	DWORD getSize();
	IMAGE_SECTION_HEADER * addSection(DWORD size,char *data);
	void close();
	void open();
	static char *formatErrorMessage(int errorcode);
	static DWORD __inline roundUp(DWORD val,DWORD alignment)
	{
		if( val % alignment )
			return (val + (alignment - (val % alignment)));
		return val;
	}
	DWORD roundToFileAlignment(DWORD val);
	IMAGE_SECTION_HEADER* sectionHeader(int index);
	IMAGE_NT_HEADERS *ntHeaders;
	IMAGE_DOS_HEADER *dosHeader;
	char *mappedFile;
	enum Exception {
		INVALID_MZ_SIG		= -1,
		INVALID_PE_SIG		= -2,
		INVALID_MAGIC		= -3,
		INVALID_SIZE		= -4,
		OUT_OF_BOUNDS		= -5,
		FILE_NOT_OPENED		= -6
	};

private:

	DWORD fileSize;
	bool fileOpened;
	HANDLE file,mapping;
	char *filename;
	IMAGE_SECTION_HEADER *sectionTable;
};

#endif